### @users: Attention : this part should be modified if you do not encode GF, Ap, Lp...as 1, 2, 3
###@users: and according to the nutrients you are studying.
###the names of the conditions should have _, not spaces


library(stringr)
library(tibble)
library(dplyr)
library(tidyr)
library(ggplot2)
library(coxme)
library(multcomp)

################################################################################################################################
ggplotprep2 = function(x, times){
  d = data.frame(condition=rep(names(x$strata), x$strata), time=x$time, survival=x$surv, upper=x$upper, lower=x$lower)
  fillup0 = function(s) rbind(c(condition=s, time=0, survival=1, upper=1, lower=1), d[d$condition==s, ], deparse.level = 0)
  
  indexes = function(x, time) {
    if(x%in%time) return(x)
    return(floor(time[which.min(abs(time[time<x]-x))]))
  }
  
  fillup = function(s) {
    d.temp = d[d$condition==s, ]
    time = as.numeric(d.temp$time)
    id = sapply(times, indexes, time=time)
    d.temp = d.temp[match(id, time), ]
    d.temp$time = times
    return(d.temp)
  }
  
  if(times[1]==0) d = do.call("rbind", sapply(names(x$strata), fillup0, simplify=F))
  d = do.call("rbind", sapply(names(x$strata), fillup, simplify=F))
  clean.name = function(name) unlist(lapply(strsplit(as.character(name), split="="), function(x) x[2]))
  d = data.frame(Condition=clean.name(d$condition), Time=as.numeric(d$time), Survival=as.numeric(d$survival), upper=as.numeric(d$upper), lower=as.numeric(d$lower))
  return(d)
}

extract_coxme_table <- function (mod){
  beta <- fixef(mod)
  nvar <- length(beta)
  nfrail <- nrow(mod$var) - nvar
  se <- sqrt(diag(mod$var)[nfrail + 1:nvar])
  z<- round(beta/se, 2)
  p<- format(as.numeric(pchisq((beta/se)^2, 1,lower.tail = F)), 4)
  table=data.frame(cbind(beta,se,z,p))
  return(table)
}
################################################################################################################################
SuperSmallfont= 6
Smallfont= 8
Mediumfont= 10
Largefont= 14
verylargefont = 16
sizepoint= 0.7
linesize=0.35
meansize = 1.5
Margin=c(0,0,0,0)
fontsizeaxes = 12
fontsizeaxes2 = 10
################################################################################################################################


path.to.data = "~/Documents/new_stats"

rm(d,path,model)
d = list()
path = list()
for(f in list.files(path=path.to.data,pattern="*.csv$",recursive=T,full.names=T)) {
  nom = gsub(".*/(.*).csv","\\1",f)
  cat(nom,"\n")
  path[[nom]] = gsub("(.*)/.*csv","\\1/",f)
  d[[nom]] = read.table(f,header=T,sep=";",dec=".", quote="\"")
  
}

tab = d[["DT_NEaa 20180419"]]

tab = 
  tab%>%
  rename(Total_Dev_Time=Condition)%>%
  gather(key = Conditions,
         value = Nber_eclosion,
         starts_with("X"))

list_rep = NULL
for (i in 1:20){
  for(j in 1:5){
    list_rep2 = rep(paste("Rep",j,sep="_"),17)
    list_rep = c(list_rep ,list_rep2 )
  }
}
tab$Rep = list_rep

tab = 
  tab%>%
  separate(Conditions, c("Bacteria","Nutrient"), "_")

tab$Bacteria = ifelse(tab$Bacteria=="X1","GF",
                      ifelse(tab$Bacteria=="X2","Ap",
                             ifelse(tab$Bacteria=="X3","Lp low",
                                    ifelse(tab$Bacteria=="X4","Lp high",
                                           "Ap:Lp"))))

tab$Nutrient[grep("Asn",tab$Nutrient)] = "Asn"
tab$Nutrient[grep("Asp",tab$Nutrient)] = "Asp"
tab$Nutrient[grep("DAla",tab$Nutrient)] = "D Ala"
tab$Nutrient[grep("Pro",tab$Nutrient)] = "Pro"


tab = 
  subset(tab,!is.na(Nber_eclosion))%>%
  uncount(weights = Nber_eclosion)

tab=
  tab%>%
  dplyr::select(Bacteria,Nutrient,Rep,Total_Dev_Time)%>%
  mutate(Eclosion=1,
         Group=paste(Bacteria,Nutrient,sep="_"))

tab=
  tab%>%
  mutate_if(is.character,as.factor)


################################################################################################################################

survdata = survfit(Surv(Total_Dev_Time,Eclosion)~ Group, tab) # generate survival data
toplot = ggplotprep2(survdata, times=c(seq(0,max(tab$Total_Dev_Time),by=1))) # to create dataframe for survival ## on peut adapter selon les jours auxquels on a compté

toplot[,c(3:5)] = I(1 - toplot[,c(3:5)]) # to inverse survival

toplot=
  toplot%>%
  separate(Condition, c("Bacteria","Nutrient"), "_",remove=F)

ggplot(toplot, aes(x=Time,y=Survival,colour=Bacteria))+
  geom_line(
    #aes(linetype=Bacteria),
    size=0.6)+
  geom_point(
    #aes(shape=Nutrient),
    size = 1) +
  geom_errorbar(data=toplot,aes(ymin=lower, ymax=upper,colour=Bacteria), width=.1, alpha=0.4, size=1, show.legend=FALSE)+
  #facet_grid(.~Bacteria)+
  facet_grid(Nutrient~.)+
  scale_colour_manual("",
                      limits=c("Ap", "Ap:Lp", "GF", "Lp low", "Lp high"),
                      values=c("blue","cadetblue","black","plum3","firebrick3"))+
  #  scale_linetype_manual("",
  #                        limits=c("Asn", "Asp", "D Ala", "Pro"),
  #                        values=c("solid","dotted","dashed","dotdash"))+
  scale_shape_manual("",
                     limits=c("Asn", "Asp", "D Ala", "Pro"),
                     values=c(15,16,15,16,15))+
  #geom_ribbon(aes(ymin=lower,ymax=upper),linetype=1, size=0.1, alpha=0.2,show.legend = FALSE)+
  scale_x_continuous("Time to pupation (in days)",
                     limits=c(4, 17),
                     breaks=c(seq(4,17,by=1)))+
  scale_y_continuous("Proportion of pupation",
                     limits=c(0, 1),
                     breaks=c(0,0.2,0.4,0.6,0.8,1))+
  theme(axis.title.x = element_text(size=Smallfont,colour="black"),
        axis.title.y = element_text(size=Smallfont,colour="black"),
        axis.line.x = element_line(colour="black",size=0.75),
        axis.line.y = element_line(colour="black",size=0.75),
        axis.ticks.x = element_line(size = 0.75),
        axis.ticks.y = element_line(size = 0.75),
        axis.text.x = element_text(size=Smallfont,colour="black"),
        axis.text.y = element_text(size=Smallfont,colour="black"),
        plot.margin = unit(Margin, "cm"),
        legend.direction = "vertical", 
        legend.box = "vertical",
        legend.position = c(0.95,0.9),
        legend.key.height = unit(0.3, "cm"),
        legend.key.width= unit(0.3, "cm"),
        strip.text.x = element_text(size =Mediumfont, colour = "black"),
        strip.text.y = element_text(size =Mediumfont, colour = "black",face="italic"),
        legend.title = element_text(size=Mediumfont,colour="black"),
        legend.key = element_rect(colour = 'white', fill = "white", linetype='dashed'),
        legend.text = element_text(size=Smallfont),
        legend.background = element_rect(fill=NA),
        panel.background = element_blank())+
  guides(shape=guide_legend(ncol=1),
         fill=guide_legend(ncol=1),
         col=guide_legend(ncol=1))


################################################################################################################################

# Withot Asn because it does not have GF treatment
tmp = subset(tab,Nutrient!="Asn")
tmp$Nutrient=factor(tmp$Nutrient)
tmp$Bacteria=factor(tmp$Bacteria)
tmp$Group=factor(tmp$Group)

model_Surv = coxme(Surv(Total_Dev_Time,Eclosion) ~ 1 + (1|Rep), data= tmp)
model_Surv1 = coxme(Surv(Total_Dev_Time,Eclosion) ~  Bacteria + (1|Rep), data= tmp)
model_Surv2 = coxme(Surv(Total_Dev_Time,Eclosion) ~ Nutrient  + (1|Rep), data= tmp)
model_Surv3 = coxme(Surv(Total_Dev_Time,Eclosion) ~ Nutrient + Bacteria + (1|Rep), data= tmp)


model_Surv4 = coxme(Surv(Total_Dev_Time,Eclosion) ~ Nutrient * Bacteria + (1|Rep), data= tmp)

test_Bacteria = anova(model_Surv,model_Surv1)
test_Nutrient = anova(model_Surv,model_Surv2)
test_Int = anova(model_Surv4,model_Surv3)
test = rbind(test_Bacteria,test_Nutrient,test_Int)
test = test[c(1,2,4,6),]

#When p-value=0 (which is impossible... it just mean p-value<2.e-16) calculate the p-value manually as follow:
#pchisq( model_Surv4$loglik[[2]]-model_Surv3$loglik[[2]],1,lower.tail = F)

tab_test = data.frame(Variable=c("Null model","Bacteria","Nutrient","Bacteria x Nutrient"),
                      logLik=as.numeric(test[,1]),
                      Chisq=as.numeric(test[,2]),
                      df=as.numeric(test[,3]),
                      Pvalue=as.numeric(test[,4]))

#???posthoc test:
model_Surv_int= coxme(Surv(Total_Dev_Time,Eclosion) ~ Group + (1|Rep), data= tmp)
multcomp = glht(model_Surv_int, linfct=mcp(Group="Tukey"))
cld(multcomp)

tab_res_surv=
  extract_coxme_table(model_Surv_int) %>%
  rownames_to_column('Treatment')%>%
  mutate(Treatment=str_remove(Treatment,pattern="Group"),
         Treatment=str_replace(Treatment,pattern="_","/"),
         Treatment= as.factor(Treatment),
         beta=as.numeric(as.character(beta)),
         se=as.numeric(as.character(se)),
         z=as.numeric(as.character(z)),
         p=as.numeric(as.character(p)),
         beta_lower = as.numeric(confint(model_Surv_int)[,1]),
         beta_upper = as.numeric(confint(model_Surv_int)[,2]))


#hazard ratio diet

# Limits=c("Female",
#"Male")


ggplot(tab_res_surv, aes(x=reorder(Treatment,desc(beta)), y=beta)) + 
  geom_errorbar(aes(ymin=beta_lower, ymax=beta_upper), col="black",width=.17,  size=0.5, show.legend=FALSE)+
  geom_point( col="black",stat="identity", show.legend=FALSE,  size=1.5)+
  scale_x_discrete("Treatment")+
  # scale_colour_manual("",
  #                     limits=Limits,
  #                     values = c("darkorange2","blue"))+
  # scale_fill_manual("",
  #                   limits=Limits,
  #                   values = c("darkorange2","blue"))+
  # scale_shape_manual(Name,
  #                    limits=Limits,
  #                    values=c(21,22))+
  scale_y_continuous("log(HR) (95 % CI)\n relative to Ap:Lp on Asp",
                     limits=c(-4, 1),
                     breaks=c(seq(-4,1,by=1)))+
  geom_hline(yintercept = 0,colour="red",linetype=4)+
  theme(aspect.ratio = 1,
        panel.background = element_blank(),
        plot.margin = unit(Margin, "cm"),
        strip.text.x = element_text(size =Smallfont, colour = "black",face="italic"),
        strip.text.y = element_text(size =Smallfont, colour = "black",face="italic"),
        axis.title.x = element_text(size=Mediumfont,colour="black"),
        axis.title.y = element_text(size=Mediumfont,colour="black"),
        axis.line.x = element_line(colour="black",size=0.75),
        axis.line.y = element_line(colour="black",size=0.75),
        axis.ticks.x = element_line(size = 0.75),
        axis.ticks.y = element_line(size = 0.75),
        axis.text.x = element_text(size=Smallfont,colour="black",angle=45,hjust=1),
        axis.text.y = element_text(size=Smallfont,colour="black"),
        legend.direction = "horizontal", 
        legend.box = "vertical",
        legend.position = "none",
        legend.key.height = unit(0.4, "cm"),
        legend.key.width= unit(0.3, "cm"),
        legend.title = element_text(face="italic",size=Smallfont), 
        legend.key = element_rect(colour = 'white', fill = "white", linetype='dashed'),
        legend.text = element_text(size=Smallfont),
        legend.background = element_rect(fill=NA))+
  guides(shape=guide_legend(ncol=5),
         fill=guide_legend(ncol=5),
         col=guide_legend(ncol=5))
